<?php
/*********************************************************************
    index.php

    Helpdesk landing page. Please customize it to fit your needs.

    Peter Rotich <peter@osticket.com>
    Copyright (c)  2006,2007,2008,2009 osTicket
    http://www.osticket.com

    Released under the GNU General Public License WITHOUT ANY WARRANTY.
    See LICENSE.TXT for details.

    vim: expandtab sw=4 ts=4 sts=4:
    $Id: $
**********************************************************************/
require('client.inc.php');
//We are only showing landing page to users who are not logged in.
if($thisclient && is_object($thisclient) && $thisclient->isValid()) {
    require('tickets.php');
    exit;
}


require(CLIENTINC_DIR.'header.inc.php');
?>
<div id="index">
	<div class="Heading">
		<h1>Welcome to the support center</h1>
		<div class="Description">
			<p>In order to streamline support requests and better serve you, we utilize a support ticket system. Every support request is assigned a unique ticket number which you can use to track the progress and responses online. For your reference we provide complete archives and history of all your support requests. A valid email address is required.</p>
		</div>
	</div>
	<div class="HomeAction TicketNew">
		<h2>Open A New Ticket</h2>
		<div class="Description">
			<p>Please provide as much detail as possible so we can best assist you. To update a previously submitted ticket, please use the form to the right.</p>
		</div>
		<form method="get" action="open.php">
			<fieldset>
				<input type="submit" class="FormButton" value="Open New Ticket" />
			</fieldset>
		</form>	
	</div>
	<div class="HomeAction TicketStatus">
		<h2>Check Ticket Status</h2>
		<div class="Description">
			<p>We provide archives and history of all your support requests complete with responses.</p>
		</div>
		<form action="tickets.php" method="post">
			<fieldset>
				<label>Email:</label>
				<input type="text" name="lemail" />
			</fieldset>
			<fieldset>
				<label>Ticket#:</label>
				<input type="text" name="lticket" />
			</fieldset>
			<fieldset>
				<input type="submit" class="FormButton" value="Check Status" />
			</fieldset>
		</form>
	</div>
	<div class="Clear"></div>
</div>
<?require(CLIENTINC_DIR.'footer.inc.php'); ?>
