<?php

	if(!defined('OSTCLIENTINC') || !is_object($thisclient) || !is_object($ticket)) die('Kwaheri'); //bye..see ya
	
	//Double check access one last time...
	if(strcasecmp($thisclient->getEmail(),$ticket->getEmail())) die('Access Denied');

	$info=($_POST && $errors)?Format::htmlchars($_POST):array(); //Re-use the post info on error...savekeyboards.org

	//Making sure we don't leak out internal dept names
	//We roll like that...
	$dept = $ticket->getDept();
	$dept=($dept && $dept->isPublic())?$dept:$cfg->getDefaultDept();

?>
<div id="viewticket">
	<div class="ErrorBlock">
  <?if($errors['err']) {?>
		<p id="errormessage"><?=$errors['err']?></p>
<?}elseif($msg) {?>
		<p id="infomessage"><?=$msg?></p>
<?}elseif($warn) {?>
		<p id="warnmessage"><?=$warn?></p>
 <?}?>
	</div>
	<div class="Heading">
		<h2>Ticket #<?=$ticket->getExtId()?></h2>
		<a class="Action" href="view.php?id=<?=$ticket->getExtId()?>">Refresh</a>        
		<a class="Action" href="view.php">Back to Tickets</a>        
		<div id="Clear"></div>
	</div>
	<table class="TicketInfo">
		<colgroup style="width:100px;"></colgroup>
		<colgroup></colgroup>
		<colgroup style="width:100px;"></colgroup>
		<colgroup></colgroup>
		<tr>
			<td class="ColLabel"><strong>Ticket Status:</strong></td>
			<td><span><?=ucfirst($ticket->getStatus())?></span></td>
			<td class="ColLabel"><strong>Name:</strong></td>
			<td><span><?=Format::htmlchars($ticket->getName())?></span></td>
		</tr>
		<tr>
			<td class="ColLabel"><strong>Department:</strong></td>
			<td><span><?=Format::htmlchars($dept->getName())?></span></td>
			<td class="ColLabel"><strong>Email:</strong></td>
			<td><span><?=$ticket->getEmail()?></span></td>
		</tr>
		<tr>
			<td class="ColLabel"><strong>Create Date:</strong></td>
			<td><span><?=Format::db_datetime($ticket->getCreateDate())?></span></td>
			<td class="ColLabel"><strong>Phone:</strong></td>
			<td><span><?=Format::phone($ticket->getPhoneNumber())?></span></td>
		</tr>
	</table>
	<h1>Subject: <?=Format::htmlchars($ticket->getSubject())?></h1>
	<div id="ticketthread">
 <?
	//get messages
	$sql='SELECT msg.*, count(attach_id) as attachments  FROM '.TICKET_MESSAGE_TABLE.' msg '.
		' LEFT JOIN '.TICKET_ATTACHMENT_TABLE.' attach ON  msg.ticket_id=attach.ticket_id AND msg.msg_id=attach.ref_id AND ref_type=\'M\' '.
		' WHERE  msg.ticket_id='.db_input($ticket->getId()).
		' GROUP BY msg.msg_id ORDER BY created';
	$msgres =db_query($sql);
	while ($msg_row = db_fetch_array($msgres)):
?>
		<div class="Incoming">
			<div class="ThreadDate"><?=Format::db_daydatetime($msg_row['created'])?></div>
			<div class="Member">(You)</div>
<?if($msg_row['attachments']>0){ ?>
			<div class="Attachments"><?=$ticket->getAttachmentStr($msg_row['msg_id'],'M')?></div>
<?}?>
			<div class="Message"><?=Format::display($msg_row['message'])?></div>
		</div>
<?
		//get answers for messages
		$sql='SELECT resp.*,count(attach_id) as attachments FROM '.TICKET_RESPONSE_TABLE.' resp '.
			' LEFT JOIN '.TICKET_ATTACHMENT_TABLE.' attach ON  resp.ticket_id=attach.ticket_id AND resp.response_id=attach.ref_id AND ref_type=\'R\' '.
			' WHERE msg_id='.db_input($msg_row['msg_id']).' AND resp.ticket_id='.db_input($ticket->getId()).
			' GROUP BY resp.response_id ORDER BY created';
		//echo $sql;
		$resp =db_query($sql);
		while ($resp_row = db_fetch_array($resp)) {
			$respID=$resp_row['response_id'];
			$name=$cfg->hideStaffName()?'staff':Format::htmlchars($resp_row['staff_name']);
?>
		<div class="Outgoing">
			<div class="ThreadDate"><?=Format::db_daydatetime($resp_row['created'])?></div>
			<div class="Member">(<?=$name?>)</div>
<?if($resp_row['attachments']>0){ ?>
			<div class="Attachments"><?=$ticket->getAttachmentStr($respID,'R')?></div>
<?}?>
			<div class="Message"><?=Format::display($resp_row['response'])?></div>
		</div>
 <?
		} //endwhile...response loop.
            $msgid =$msg_row['msg_id'];
        endwhile; //message loop.
?>
	</div>
  <?if($ticket->isClosed()) {?>
	<h2 class="Reopen">Ticket will be reopened on message post</h2>
 <?}?>
	<div name="reply"></div>
	<form action="view.php?id=<?=$id?>#reply" method="post" enctype="multipart/form-data">
		<fieldset>
			<input type="hidden" name="id" value="<?=$ticket->getExtId()?>" />
			<input type="hidden" name="respid" value="<?=$respID?>" />
			<input type="hidden" name="a" value="postmessage" />
		</fieldset>
		<fieldset id="form-message" class="Required">
			<label>Enter Message:</label>
			<textarea rows="5" cols="80" name="message"><?=$info['message']?></textarea>
			<span class="FormError"><?=$errors['message']?></span>
		</fieldset>
<? if($cfg->allowOnlineAttachments()) {?>
		<fieldset id="form-attachment">
			<label>Attach File:</label>
			<input type="file" name="attachment" value="<?=$info['attachment']?>" />
			<span class="FormError"><?=$errors['attachment']?></span>
		</fieldset>
<?}?>
		<fieldset id="button-group">
			<input class="FormButton" type="submit" value="Post Reply" />
			<input class="FormButton" type="reset" value="Reset" />
			<input class="FormButton" type="button" value="Cancel" onclick='window.location.href="view.php"' />
		</fieldset>
	</form>
</div>
<div class="Clear"></div>
